clear all
close all

load TBL3969_line.mat

% Now you have the following data:
% dd: delta_99 in code units
% ll: lstar in code units
% ret: Re_theta
% t:  time in code units
% ut: u_tau in code units
% yy: vertical position in code units
%
% uline,vline,wline,pline: raw data along as a array
% tauline: du/dy in code untis
%
% Note that the total data contains 54016 time samples at 768
% spanwise positions.

% Example to plot a 1D vertical cut

plot(yy/ll,uline(1,:)/ut)
xlabel('y+');ylabel('u+')

% Example of a 1D time series
figure
plot(t,tauline(:)/(ut/ll))
xlabel('t');ylabel('tau+')


