clear all
close all

% Read data file: Here, we load Re_theta=3969, 3072 time instants
% (of 54016 total available)
% The file has size 3591178432 bytes.
% The total time-series data size would be roughly 60GB.
%
% In addition, we have a total of 9 Reynolds numbers:
% 1000, 1421, 2149, 2536, 2937, 3273, 3626, 3969, 4268
% The complete time-series data are about 600GB.
load TBL3969_3072.mat

% Now you have the following data:
% dd: delta_99 in code units
% ll: lstar in code units
% ret: Re_theta
% t:  time in code units
% ut: u_tau in code units
% yy: vertical position in code units
%
% Code units are normalised by 
% U_\infty   : free-stream velocity
% \delta^*_0 : displacement thickness of the (laminar) inflow
% \nu        : viscosity
%
% udata,vdata,wdata,pdata: raw data as a array
% taudata: du/dy in code untis
%
% Note that the total data contains 54016 time samples at 768
% spanwise positions.

disp(sprintf('Date of data file %i',dateofdata))

% Example to plot a 1D vertical cut
figure
plot(yy/ll,squeeze(udata(1,1,:))/ut)
xlabel('y+');ylabel('u+')

% Example of a 1D time series
figure
plot(t,taudata(:,1)/(ut/ll))
xlabel('t');ylabel('\tau+')

% Example of the mean flow
umean=mean(squeeze(reshape(udata,[],1,50)));
urms = sqrt(mean(squeeze(reshape(udata.*udata,[],1,50)))-umean.^2);
figure
hold on
plot(yy/ll,umean/ut)
xlabel('y+');ylabel('<u>+')
figure
hold on
plot(yy/ll,urms/ut)
xlabel('y+');ylabel('u_{rms}+')

