%--------------------------------------------------------------------------
%
% Kuramoto Sivashinsky equation
%
% Velocity root-mean-square plot.
%
% Plot of the velocity root-mean-square in the common plot. It needs the
% definition of:
%   - x:          grid generated by KS_init
%   - v_rms:      rms of the velocity, size(v_rms) = [nq 1]
%   - rms_style:  line style
%   - rms_legend: legend entry
%
% 
% Nicolo' Fabbiane, December 2013
% KTH Mechanics
% nicolo@mech.kth.se
%
%--------------------------------------------------------------------------

figure(1001)

hold on

semilogy(x,v_rms,rms_style,'Linewidth',2)

set(gca,'YScale','log')
axis([0 800 1e-2 1e2])
xlabel('x'); ylabel('v_{rms}'); grid on

% Update legend
legend_string = get(legend,'String');
legend_string{length(legend_string)+1} = rms_legend;
legend(legend_string,'Location','NW')

hold off