close all; clear; set(0,'DefaultLineLineWidth',1,'DefaultLineMarkerSize',7);
%
%---------------------------------------------------------------------------------------
%
% The spatial support of the first 20 global (a), POD (b) and balanced modes
% (c). It is defined as the region where the amplitude of a particular mode
% is larger than $1\%$ of its maximum amplitude. The location of the input
% (just upstream of branch I) and output (at branch II) is marked with red
% and green dashed lines, respectively. The global modes span only the
% region around branch II. The first POD modes (b) are located at branch II,
% even though the higher modes quickly recover the input. The balanced modes
% (c) cover the region between input and output with only three modes. The
% areas marked with light gray in (a) and (c) represent the spatial support
% of the adjoint modes for the global and balanced modes. The spatial
% separation in $x$ of the direct and adjoint modes, shown in (a) for global
% modes, is absent in (b) for the balanced modes.
%
%  Shervin Bagheri, 16 March 2008
%  KTH Mechanics
%  shervin@mech.kth.se
%
%---------------------------------------------------------------------------------------
%

%
%  Parameters of the subcritical Ginzburg-Landau equation
%
nx = 220;
[xh,A,Q,cd,U,mu0,mu2,cc,gam] = setup_subcritical(nx);

%
% Unstable domain: branch I and II
%
x1=-sqrt(-2*mu0/mu2);
x2=sqrt(-2*mu0/mu2);


%
% Direct and adjoint global modes
%
Aa=Q\A'*Q;
[Us, ll] = oeig(A,Q);
[Ua, lla] = oeig(Aa,Q);
Ua2=Ua./(ones(nx,1)*diag(Ua'*Q*Us)');


%
% Input at x=-11
% Covariance W=1
%
var = 0.4;
xw = -11; 
B = exp(-((xh-xw)/var).^2);
W=1;		

%
% Output C at x=9
%
w = diag(Q);
xs = 9;
C = exp(-((xh-xs)/var).^2);C=C';

%
% POD modes
%
k = 20;
V  =  mylyap(A,A',B*B');
[POD,SPOD] = oeig(V);
POD = POD(:,1:k); % truncate

%
% Balanced truncation
%
Va = mylyap(A',A,C'*C);
X = sqrth(V); X = X';
Y = sqrth(Va); Y = Y';
[UU,Sig,VV] =  svd(Y'*X);
U1 = UU(:,1:k);
V1 = VV(:,1:k);
Sig1 = (Sig(1:k,1:k));
T1 = X*V1*Sig1^(-0.5); % balanced modes
S1 = Y*U1*Sig1^(-0.5); %  adjoint balanced modes


%
% Plot spatial support of modes
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
y0=0;
col = 0.3;
col2 = 0.5;
col3 = 0.7;
tol = 0.02;
for M=1:20
  ymax = y0+0.85000;
  tak = linspace(0,ceil(ymax),200);

  subplot(1,3,3);
  S11 = find(abs(S1(:,M))>tol*max(abs(S1(:,M))));
  xp = xh(S11(1));   xe = xh(S11(end));
  hold on;
  fill([xp xe xe xp xp], [y0 y0 ymax ymax y0],[col2 col2 col2],'edgecolor',[col2 col2 col2])

  T11 = find(abs(T1(:,M))>tol*max(abs(T1(:,M))));
  xp = xh(T11(1));   xe = xh(T11(end));
  fill([xp xe xe xp xp], [y0 y0 ymax ymax y0],[col col col],'edgecolor',[col col col])
  
  subplot(1,3,1);
  U12 = find(abs(Ua2(:,M))>tol*max(abs(Ua2(:,M))));
  xp = xh(U12(1));   xe = xh(U12(end));
  hold on;
  fill([xp xe xe xp xp], [y0 y0 ymax ymax y0],[col2 col2 col2],'edgecolor',[col2 col2 col2])

  U11 = find(abs(Us(:,M))>tol*max(abs(Us(:,M))));
  xp = xh(U11(1));   xe = xh(U11(end));
  hold on;
  fill([xp xe xe xp xp], [y0 y0 ymax ymax y0],[col col col],'edgecolor',[col col col])

  subplot(1,3,2);
  P11 = find(abs(POD(:,M))>tol*max(abs(POD(:,M))));
  xp = xh(P11(1));   xe = xh(P11(end));
  hold on;
  fill([xp xe xe xp xp], [y0 y0 ymax ymax y0],[col col col],'edgecolor',[col col col])

  y0 = ymax+0.15000;
  drawnow
end

%
% Find and plot the location of input and output
%
d(1)=find(xh>xw,1);
d(2)=find(xh<xs,1,'last');
subplot(1,3,1)
  hold on;
  plot(xh(d(1))*ones(length(tak)),tak,'r--');
  plot(xh(d(2))*ones(length(tak)),tak,'g--');
  setlabel('x','')
  
subplot(1,3,2)
  plot(xh(d(1))*ones(length(tak)),tak,'r--');
  plot(xh(d(2))*ones(length(tak)),tak,'g--');
  xlim([-70 70])
  setlabel('x','')

subplot(1,3,3)
  plot(xh(d(1))*ones(length(tak)),tak,'r--');
  plot(xh(d(2))*ones(length(tak)),tak,'g--');
  xlim([-70 70])
  setlabel('x','')


  
  