close all;clear; set(0,'DefaultLineLineWidth',0.5,'DefaultLineMarkerSize',7);
%
%---------------------------------------------------------------------------------------
%
%  Global, POD and balanced modes of Ginznurg-Landau equation
%
% (a) two first direct and adjoint global modes
%
% (b) two first POD modes
%
% (c) two first balanced modes
%
%  Shervin Bagheri, 16 March 2008
%  KTH Mechanics
%  shervin@mech.kth.se
%
%---------------------------------------------------------------------------------------
%

%
%  Parameters of the subcritical Ginzburg-Landau equation
%
nx = 220;  
[xh,A,Q,cd,U,mu0,mu2,cc,gam] = setup_subcritical(nx);

%
% Direct and adjoint global modes
%
Aa=Q\A'*Q;
[Us, ll] = oeig(A,Q);
[Ua, lla] = oeig(Aa,Q);
Ua2=Ua./(ones(nx,1)*diag(Ua'*Q*Us)');

%
% Unstable domain: branch I and II
%
x1=-sqrt(-2*mu0/mu2);
x2=sqrt(-2*mu0/mu2);

%
% Input at x=-11
% Covariance W=1
%
var = 0.4;
xw = -11; 
B1 = exp(-((xh-xw)/var).^2);
W=1;		

%
% POD modes
%
V = lyap(A,B1*W*B1');
[pod,ss] = oeig(V);

%
% Output C at x=9
%
w = diag(Q);
xj = 9;
C1 = exp(-((xh-xj)/var).^2);C1=C1';
W=1;		

%
% Balanced truncation
%
Vc = lyap(A',C1'*W*C1);
r = 7; 
X = sqrth(V); X = X';
Y = sqrth(Vc); Y = Y';
[UU,Sig,VV] =  svd(Y'*X);
U1 = UU(:,1:r);
V1 = VV(:,1:r);
Sig1 = (Sig(1:r,1:r));
T1 = X*V1*Sig1^(-0.5); 
S1 = Y*U1*Sig1^(-0.5); 


%
% Plot global modes (fig 7)
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
subplot(2,1,1)
ymax = 1.19
L=30;
MM=1;
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on;
plot(xh,abs(Us(:,MM))/max(abs(Us(:,MM))),'k',xh,real(Us(:,MM))/max(abs(Us(:,MM))),'k--',xh,-abs(Us(:,MM))/max(abs(Us(:,MM))),'k','LineWidth',0.5);axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,abs(Ua(:,MM))/max(abs(Ua(:,MM))),'r',xh,real(Ua(:,MM))/max(abs(Ua(:,MM))),'r--',xh,-abs(Ua(:,MM))/max(abs(Ua(:,MM))),'r');axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,zeros(nx),'k')
hold off;
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.12 0.44 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'(a)'});
xlim([-L L]);ylim([-ymax-0.01 ymax+0.02])
setlabel('x','')

subplot(2,1,2)
MM=2;
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on;
plot(xh,abs(Us(:,MM))/max(abs(Us(:,MM))),'k',xh,real(Us(:,MM))/max(abs(Us(:,MM))),'k--',xh,-abs(Us(:,MM))/max(abs(Us(:,MM))),'k'); axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,abs(Ua(:,MM))/max(abs(Ua(:,MM))),'r',xh,real(Ua(:,MM))/max(abs(Ua(:,MM))),'r--',xh,-abs(Ua(:,MM))/max(abs(Ua(:,MM))),'r');axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,zeros(nx),'k')
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.12 -0.04 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'(b)'});
xlim([-L L]);ylim([-ymax-0.01 ymax+0.02])
setlabel('x','')

%
% Plot pod modes (fig 17)
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
subplot(2,1,1)
MM=1;
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on;
plot(xh,abs(pod(:,MM))/max(abs(pod(:,MM))),'k',xh,real(pod(:,MM))/max(abs(pod(:,MM))),'k--',xh,-abs(pod(:,MM))/max(abs(pod(:,MM))),'k');axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,zeros(nx),'k')
hold off;
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.12 0.44 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'(a)'});
xlim([-L L]);ylim([-ymax-0.01 ymax+0.02])
setlabel('x','')

subplot(2,1,2)
MM=2;
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on;
plot(xh,abs(pod(:,MM))/max(abs(pod(:,MM))),'k',xh,real(pod(:,MM))/max(abs(pod(:,MM))),'k--',xh,-abs(pod(:,MM))/max(abs(pod(:,MM))),'k'); axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,zeros(nx),'k')
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.12 -0.04 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'(b)'});
xlim([-L L]);ylim([-ymax-0.01 ymax+0.02])
setlabel('x','')


%
% Plot balanced modes (fig 23)
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
subplot(2,1,1)
MM=1;
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on;
plot(xh,abs(T1(:,MM))/max(abs(T1(:,MM))),'k',xh,real(T1(:,MM))/max(abs(T1(:,MM))),'k--',xh,-abs(T1(:,MM))/max(abs(T1(:,MM))),'k');axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,abs(S1(:,MM))/max(abs(S1(:,MM))),'r',xh,real(S1(:,MM))/max(abs(S1(:,MM))),'r--',xh,-abs(S1(:,MM))/max(abs(S1(:,MM))),'r'); axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,zeros(nx),'k')
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.12 0.44 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'(a)'});
hold off;
xlim([-L L]);ylim([-ymax-0.01 ymax+0.02])
setlabel('x','')

subplot(2,1,2)
MM=2;
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on;
plot(xh,abs(T1(:,MM))/max(abs(T1(:,MM))),'k',xh,real(T1(:,MM))/max(abs(T1(:,MM))),'k--',xh,-abs(T1(:,MM))/max(abs(T1(:,MM))),'k'); axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,abs(S1(:,MM))/max(abs(S1(:,MM))),'r',xh,real(S1(:,MM))/max(abs(S1(:,MM))),'r--',xh,-abs(S1(:,MM))/max(abs(S1(:,MM))),'r'); axis([-xh(end) xh(end) -1.2 1.2 ]);
plot(xh,zeros(nx),'k')
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.12 -0.04 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'(b)'});
xlim([-L L]);ylim([-ymax-0.01 ymax+0.02])
setlabel('x','')
hold off;



