function q = io_impulse(A,B,tvec)

%%%% %%%% %%%% %%%% %%%% %%%% %%%% %%%% %%%% 
% Computes the impulse response
% 
% input: A -- operator
%            B -- Input vector
%            tvec -- time vector
%
% output: q -- impulse response
%
% Shervin Bagheri (December,2006)
%
%%%% %%%% %%%% %%%% %%%% %%%% %%%% %%%% %%%% 

dt = tvec(2) - tvec(1);
nx = length(A);

expmat = expm(A*dt);
H=eye(nx);
q=zeros(nx,length(tvec));

tind2=1;
for tind=1:length(tvec);
  H=H*expmat;
  q(:,tind)=H*B;
  if tind==tind2
    disp (['io_impulse: time=' num2str(tvec(tind))])
    tind2=tind+50;
  end
end





    