close all; clear; set(0,'DefaultLineLineWidth',0.5,'DefaultLineMarkerSize',4);
%
%---------------------------------------------------------------------------------------
%
%  Impulse response of the Ginzburg-Landau equation: 
%
%  (a) The Impulse response state response to an impulse introduced at $t=0$ and
%  $x_w=-11$.
%
%  (b) The impulse response at branch II. The convective character of the
%  instability is evident: a wavepacket grows as it enters the unstable domain,
%  but is gradually convected away from this domain before it begins to decay.
%
%
%  Shervin Bagheri, 16 March 2008
%  KTH Mechanics
%  shervin@mech.kth.se
%
%---------------------------------------------------------------------------------------
%

%
%  Parameters of the subcritical Ginzburg-Landau equation
%
nx = 220;
[xh,A,Q,cd,U,mu0,mu2,cc,gam,muc] = setup_subcritical(nx);

%
% Unstable domain: branch I and II
%
x1 = -sqrt(-2*(mu0-cc^2)/mu2);
x2 = sqrt(-2*(mu0-cc^2)/mu2);

% 
% Input B at x=-11
%
var = 0.4; 
xw = -11;
B1 = exp(-((xh-xw)/var).^2);

%
% Output C1 at branch 1
%
xs = x1;
w = diag(Q);
C1 = exp(-((xh-xs)/var).^2).*w;C1 = C1';

%
% Output C2 at branch 2
%
xj = x2;
C2 = exp(-((xh-xj)/var).^2).*w;C2 = C2';  

%
% Time vector
%
tmax = 300; dt = 1.;
t = 0:dt:tmax; 
nt = length(t);

%
% Initialize state vector
%
q   = zeros(nx,nt);

%
% Integrate in time
%
expmat = expm(A*dt);
H = eye(nx);
for tind=1:length(t)
  H = H*expmat;
  q(:,tind) = H*B1(:,1);
  E(tind) = real(diag(q(:,tind)'*Q*q(:,tind)));
end

%
% Plot state response to impulse (Fig 12)
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 8]);
%axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
subplot(8,1,[1:6]);
MM = 70;
surf(t,xh(MM:nx-MM),real(q(MM:nx-MM,:)));
ccolor; setlabel('','x'); axis tight; hold on;
view(2); 


%
% Find and plot branch I and II
%
d=find(xh>x2,1,'first');
d2=find(xh>x1,1,'first');
plot3(t,xh(d)*ones(length(t),1),real(q(d,:)),'k--')
plot3(t,xh(d2)*ones(length(t),1),real(q(d2,:)),'k--')

%
% Plot impulse response
%
subplot(8,1,[7:8]); 
%figure(2); set(gcf,'Position',[100 80 600 180])
plot(t,real(C2*q(:,:)),'k',t,abs(C2*q(:,:)),'r',t,-abs(C2*q(:,:)),'r')
setlabel('t','y')

