close all; clear; set(0,'DefaultLineLineWidth',1,'DefaultLineMarkerSize',7);
%
%--------------------------------------------------------------------------
%
%  Local stability concepts:
% 
%
%  Fig 3: The neutral stability curve for the parallel Ginzburg-Landau 
%        equation in the (\mu_0,k)-plane.
%
%  Fig 4: The neutral absolute stability curve for the parallel 
%       Ginzburg-Landau equation in the
%      (\mu_0,U_max)-plane.
%
%
%  Shervin Bagheri, 16 March 2008
%  KTH Mechanics
%  shervin@mech.kth.se
%
%--------------------------------------------------------------------------
%

%
%  Parameters of the subcritical Ginzburg-Landau equation
%
nx = 220;
[xh,A,Q,cd,U,mu0,mu2,cc,gam] = setup_subcritical(nx);
gam = 1+sqrt(-1)*cd;
hh = sqrt(-2*mu2*gam);
Umax = U+2*cc*cd;

%
%  Criteria for Absolute Instability and Global instability
%
mut = (Umax)^2/(4*abs(gam)^2);
muc = mut+abs(hh)/2*cos(angle(gam)/2);

%
% Dispersion Relation
%
k = -2:0.01:2; nint=length(k);
omega = U*k+cd*k.^2+i*(mu0-(k-cc).^2);

%
% Neutral Curve: stable ---->  unstable
%
NC = (k-cc).^2;   

%
% Neutral Curve: Convect Unstable  ---->  Absolute Unstable
%
ymin=-14.;ymax=14;
UU=ymin:0.1:ymax;  
SD = UU.^2/(4*abs(gam)^2); 

%
% Plot neutral curve (Fig3)
%
xmin = -0.6; xmax = 2;
ymin = -1.3; ymax = 1.7;
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 0.7*8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
plot(NC,k,'k'); hold on;
fill([NC xmax xmax],[k ymax ymin],[0.9 0.9 0.9])
plot(xmin:.1:0,cc*ones(length(xmin:.1:0)),'k--','LineWidth',1)
plot(zeros(length(ymin:0.1:cc)),ymin:0.1:cc,'k--','LineWidth',1)
ylim([ymin ymax]);xlim([xmin xmax]);
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.2 0.4 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'\omega_i<0','stable'});
annotation2 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.65 0.1 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'\omega_i>0','unstable'});
annotation3 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.2 0.15 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'k_{max}'});
annotation4 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.35 -0.2 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'\mu_{crit}'});
xlabel('\mu_0','fontsize',7,'FontName','Arial')
ylabel('k','fontsize',7,'FontName','Arial')

%
% Plot neutral curve (Fig4)
%
xmin=-4;xmax=20;
ymin = -13; ymax = 13;
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 0.7*8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
plot(SD,UU,'k');hold on
fill([SD xmax xmax],[UU ymax ymin],[0.9 0.9 0.9])
annotation1 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.29 0.42 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'\mu_0<\mu_t convectively', 'unstable'});
annotation2 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.65 0.15 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'\mu_0>\mu_t','absolutely','unstable'});
annotation3 = annotation(fig1,'textbox', 'LineStyle','none','Position',[0.15 0.13 0.5 0.5], 'FontName','Arial',  'FontSize',7,  'String',{'\mu_0<0','stable'});
plot(zeros(length(UU)),linspace(ymin,ymax,length(UU)),'k--','LineWidth',1)
ylim([ymin ymax]);xlim([xmin xmax]);
xlabel('\mu_0','fontsize',7,'FontName','Arial')
ylabel('U_{max}','fontsize',7,'FontName','Arial')
set(gca,'YTick',[-12 -9 -6 -3 0 3 6 9 12]);  hold off;
