close all; clear; set(0,'DefaultLineLineWidth',0.5,'DefaultLineMarkerSize',7);
%
%---------------------------------------------------------------------------------------
%
% (a) Optimal disturbance.
%
%
% (b) Optimal energy growth  a function of time:
%
%    (S) stable configuration \mu_0<0: the perturbation energy decays
%    exponentially for all time;
%
%    (CU) convectively unstable configuration 0<\mu_0<\mu_c: the perturbation
%    energy is amplified initially but decays to zero asymptotically;
%
%    (GU) globally unstable configuration \mu_c<\mu_0: the perturbation energy
%    grows exponentially asymptotically. .
%
%
%  Shervin Bagheri, 16 March 2008
%  KTH Mechanics
%  shervin@mech.kth.se
%
%---------------------------------------------------------------------------------------
%

%
%  Parameters of the supercritcal (A2), subcritical (A1) and stable (A3)
%  Ginzburg-Landau equation
%
nx = 220;
[xh,A2,Q,cd,U,mu0,mu2,cc,gam] = setup_supercritical(nx);
[xh,A3,Q,cd,U,mu0,mu2,cc,gam] = setup_stable(nx);
[xh,A1,Q,cd,U,mu0,mu2,cc,gam] = setup_subcritical(nx);

%
% Time vector
%
tmax=100; dt = 1;
tvec = 0:dt:tmax;

%
% Compute optimal growth
%
expmat1 = expm(A1*dt);
expmat2 = expm(A2*dt);
expmat3 = expm(A3*dt);

[F,Finv] = sqrth(Q);

H1 = eye(nx);
H2 = eye(nx);
H3 = eye(nx);
for tind=1:length(tvec)
  
  H1 = H1*expmat1;
  [U1,S1,V1] = svd(F*H1*Finv);
  G1(tind) = S1(1,1)^2;
  qopt(:,tind) = V1(:,1);

  H2 = H2*expmat2;
  [U2,S2,V2] = svd(F*H2*Finv);
  G2(tind) = S2(1,1)^2;

  H3 = H3*expmat3;
  [U3,S3,V3] = svd(F*H3*Finv);
  G3(tind) = S3(1,1)^2;

 
end

%
% Optimal disturbance
%
[t0,ind] = max(G1);
q0 = Finv*qopt(:,ind);

%
% Unstable domain: branch I and II
%
x1 = -sqrt(-2*mu0/mu2);
x2 = sqrt(-2*mu0/mu2);

%
% Plot optimal disturbance (Fig 8)
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 4]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
ymax=.5; 
fill([x1 x2 x2 x1 x1], [-ymax -ymax ymax ymax -ymax],[0.9 0.9 0.9],'edgecolor',[0.9 0.9 0.9])
hold on; plot(xh,abs(q0),'k',xh,real(q0),'b',xh,imag(q0),'r');
axis([-20 20 -ymax ymax ]);
setlabel('x','q_0')

%
% Plot optimal growth curves (Fig 9)
%
set(0,'Units','Centimeters');
fig1=figure('Units','Centimeters','Position',[1 1 8 0.7*8]);
axes1 = axes('FontName','arial', 'FontSize',7, 'Parent',fig1);
semilogy(tvec,G1,'k',tvec,G2,'k',tvec,G3,'k','LineWidth',0.5)
setlabel('t','E_{max}'); 
axis([0 tmax 1e-2 1e5])
annotation1 = annotation( fig1,'textbox', 'Position',[0.4393 0.58 0.1 0.06429], 'LineStyle','none', 'FitHeightToText', ...
'off','FontName','arial', 'FontSize',7, 'String',{'CU'});
annotation2 = annotation( fig1,'textbox', 'Position',[0.445 0.72 0.1  0.06429], 'LineStyle','none', 'FitHeightToText','off', 'FontName','arial', 'FontSize',7, 'String',{'GU'});
annotation3 = annotation( fig1,'textbox', 'Position',[0.22 0.19 0.1  0.06429], 'LineStyle','none', 'FitHeightToText','off', 'FontName','arial', 'FontSize',7, 'String',{'S'});
